#!/usr/bin/perl5
# Converts 8b10b Kxx.y/Dxx.y nomenclature into hex
# by Rob Elliott, HP 1/22/2007
# elliott@hp.com

# Usage:
# perl 8b10b.pl < input.txt 
# Input format: lines containing Kxx.y Dxx.y ... 
# Output format: hex numbers ending in h, one per line
# Lines not starting with D or K are printed verbatim

while (<>) {
	if (!/^[DK]/) {
		print;	# pass through uninteresting lines
	} else {
		@words = split;	# split on whitespace by default
		foreach (@words) {
			($z, $fivebit, $threebit) = /([DK])(\d+).(\d)/;
			printf ("%02X", ($threebit << 5) | $fivebit);
		} # foreach
		print "h\n";
	} # else
} # while

