import fnmatch
import os
import subprocess
import string
 
pythonPath = "c:/program files/python25/python.exe"   # or "c:/python25/python.exe"
rootPath = string.replace(string.rstrip(os.popen('cd').readlines()[0]),'\\','/')
#rootPath = 'c:/pub/stateye/v5.080111'  # location of the .s4p files, if the current directory is not the one

# run simulations with all combinations of the following
sparmfiles = [ 'SAS2_trans*.s4p', 'Mini*.s4p', 'HP*.s4p' ]  # s4p filename(s), honors UNIX shell-style wildcards
deemps = [ '3' ] # '1', '2', '3' ]  # deemphasis settings
dfetaps = [ '2' ]  # dfetaps settings
codings = [ 'r' ]  # scrambled settings '8'=8b10b, 'r'=random


for sparmfile in sparmfiles:
    for root, dirs, files in os.walk(rootPath):
        for filename in files:
            if fnmatch.fnmatch(filename, sparmfile):
                for deemp in deemps:
                    for dfetap in dfetaps:
                        for coding in codings:
                            cmd = [\
                                pythonPath,\
                                "testcase.py",\
                                "-s", os.path.join(root, filename),\
                                "-d", deemp,\
                                "-t", dfetap,\
                                "-c", coding, 
                                ]
                            print "Running -s %s -d %s -t %s -c %s"%(filename, deemp, dfetap, coding)
                            retcode = subprocess.call(cmd)
                            print "  complete with retcode=%d"%retcode
                      
